/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  switch.h
//  Read-out of the switches
//
//  Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//******************************************************************************


#ifndef SWITCH_H
#define SWITCH_H


// bits for switches S1, S2, S3, S4
#define S1_BIT			BIT2
#define S2_BIT			BIT3
#define S3_BIT			BIT4
#define S4_BIT			BIT5

// function select register for S1, S2, S3, S4
#define S1_PSEL			P4SEL
#define S2_PSEL			P4SEL
#define S3_PSEL			P4SEL
#define S4_PSEL			P4SEL

// direction register for S1, S2, S3, S4
#define S1_PDIR			P4DIR
#define S2_PDIR			P4DIR
#define S3_PDIR			P4DIR
#define S4_PDIR			P4DIR

// output register for S1, S2, S3, S4
#define S1_POUT			P4OUT
#define S2_POUT			P4OUT
#define S3_POUT			P4OUT
#define S4_POUT			P4OUT

// input register for S1, S2, S3, S4
#define S1_PIN			P4IN
#define S2_PIN			P4IN
#define S3_PIN			P4IN
#define S4_PIN			P4IN

// pullup/-down resistor register for S1, S2, S3, S4
#define S1_RES			P4REN
#define S2_RES			P4REN
#define S3_RES			P4REN
#define S4_RES			P4REN

// definitions for switches
#define SWITCH_MODE		S1_BIT
#define SWITCH_PLUS		S2_BIT
#define SWITCH_MINUS	S3_BIT
#define SWITCH_ENABLE	S4_BIT

#define SWITCH_PIN		P4IN

#define BIT_MASK		(S1_BIT | S2_BIT | S3_BIT | S4_BIT)
#define REPEAT_MASK		(S1_BIT | S2_BIT | S3_BIT | S4_BIT)

// define time for repeat function
#define REPEAT_START    100		// after 1000ms
#define REPEAT_NEXT     20		// every 200ms


extern volatile unsigned int key_press;		// key press detect
extern volatile unsigned int key_rpt;		// key long press and repeat
extern volatile unsigned int key_state;		// debounced and inverted key state:
											// bit = 1: key pressed

// initialization of the switches
extern void init_switches(void);

// Check if a key has been pressed. Each pressed key is reported only once.
extern unsigned int get_key_press( unsigned int key_mask );

// Check if a key has been pressed long enough such that the
// key repeat functionality kicks in. After a small setup delay
// the key is reported being pressed in subsequent calls
// to this function. This simulates the user repeatedly
// pressing and releasing the key.
extern unsigned int get_key_rpt(unsigned int key_mask);

//Check if a key is pressed short.
extern unsigned int get_key_short(unsigned int key_mask);



#endif /*SWITCH_H*/
